/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.MessagingQueue;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NamedConcurrentQueue
implements MessagingQueue {
    private static LinkedBlockingQueue<Runnable> messages = null;
    private static ThreadPoolExecutor pool = null;
    private LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue(500);
    private List<MessageConsumer> consumers = new LinkedList<MessageConsumer>();
    private String name = null;

    public NamedConcurrentQueue(String name) {
        this.name = name;
        Logger.debug((String)("creating message queue " + this.name));
        this.init();
    }

    private synchronized void init() {
        if (pool != null) {
            return;
        }
        Logger.info((String)"creating thread pool");
        messages = new LinkedBlockingQueue(2000);
        pool = new ThreadPoolExecutor(1, 5, 10L, TimeUnit.SECONDS, messages, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public void sendMessage(final Message message) {
        if (message == null || pool.isTerminating() || pool.isTerminated()) {
            return;
        }
        if (this.consumers.size() == 0) {
            Logger.debug((String)"no message consumers found, ignoring message");
            return;
        }
        pool.execute(new Runnable(){

            @Override
            public void run() {
                NamedConcurrentQueue.this.deliver(message);
            }
        });
    }

    @Override
    public void sendSyncMessage(Message message) {
        if (message == null || pool.isTerminating() || pool.isTerminated()) {
            return;
        }
        if (this.consumers.size() == 0) {
            Logger.debug((String)"no message consumers found, ignoring message");
            return;
        }
        this.deliver(message);
    }

    @Override
    public void queueMessage(final Message message) {
        if (message == null || pool.isTerminating() || pool.isTerminated()) {
            return;
        }
        if (this.consumers.size() > 0) {
            this.sendMessage(message);
            return;
        }
        boolean added = this.queue.offer(new Runnable(){

            @Override
            public void run() {
                NamedConcurrentQueue.this.deliver(message);
            }
        });
        if (!added) {
            Logger.debug((String)("queue " + this.name + " full"));
        }
    }

    @Override
    public int getQueueSize() {
        if (messages == null) {
            return 0;
        }
        return messages.size();
    }

    @Override
    public void registerMessageConsumer(MessageConsumer consumer) {
        if (consumer == null) {
            return;
        }
        Logger.debug((String)("queue " + this.name + ": registering message consumer " + consumer.getClass().getName()));
        this.consumers.add(consumer);
        int size = this.queue.size();
        if (size > 0) {
            Logger.info((String)("delivering " + size + " queued messages to queue: " + this.name));
            this.queue.drainTo(messages);
        }
    }

    @Override
    public void unRegisterMessageConsumer(MessageConsumer consumer) {
        if (consumer == null) {
            return;
        }
        if (this.consumers.size() == 0) {
            Logger.debug((String)"queue contains no consumers, skip unregistering");
            return;
        }
        Logger.debug((String)("queue " + this.name + ": unregistering message consumer " + consumer.getClass().getName()));
        this.consumers.remove(consumer);
    }

    @Override
    public synchronized void close() {
        Logger.debug((String)("closing queue " + this.name));
        pool.shutdown();
    }

    @Override
    public void flush() {
        if (pool.isTerminated()) {
            return;
        }
        try {
            while (messages != null && messages.size() > 0) {
                Thread.sleep(5L);
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to flush queue", (Throwable)e);
        }
    }

    private void deliver(Message msg) {
        if (pool.isTerminating() || pool.isTerminated()) {
            Logger.warn((String)"shutdown in progress, no more messages accepted");
            return;
        }
        Logger.debug((String)("deliver message " + msg.toString()));
        MessageConsumer consumer = null;
        for (int i = 0; i < this.consumers.size(); ++i) {
            boolean send;
            consumer = this.consumers.get(i);
            Class[] expected = consumer.getExpectedMessageTypes();
            boolean bl = send = expected == null;
            if (expected != null) {
                for (int j = 0; j < expected.length; ++j) {
                    if (!expected[j].isInstance(msg)) continue;
                    send = true;
                    break;
                }
            }
            try {
                if (!send) continue;
                consumer.handleMessage(msg);
                continue;
            }
            catch (ApplicationException ae) {
                Application.getMessagingFactory().sendSyncMessage(new StatusBarMessage(ae.getMessage(), 1));
                continue;
            }
            catch (OperationCanceledException oce) {
                Logger.debug((String)("consumer " + consumer.getClass().getName() + " cancelled message " + msg));
                continue;
            }
            catch (Throwable t) {
                Logger.error((String)("consumer " + consumer.getClass().getName() + " produced an error (" + t.getClass().getName() + ": " + t + ") while consuming message " + msg));
                Logger.write((Level)Level.INFO, (String)"error while processing message", (Throwable)t);
            }
        }
    }
}

